/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityClass;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchUpdateStatement;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\u0010\u0018\u001a\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010\u0005\u001a\u00020\u00042\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u000f\u001a\u00020\u00042\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R<\u0010\u0014\u001a*\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00130\u00120\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R%\u0010\u0018\u001a\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/dao/EntityBatchUpdate;", "", "Lorg/jetbrains/exposed/dao/id/EntityID;", "id", "", "addBatch", "(Lorg/jetbrains/exposed/dao/id/EntityID;)V", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "", "execute", "(Lorg/jetbrains/exposed/sql/Transaction;)I", "Lorg/jetbrains/exposed/sql/Column;", "column", "value", "set", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Ljava/util/SortedMap;", "data", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/dao/EntityClass;", "Lorg/jetbrains/exposed/dao/Entity;", "klass", "Lorg/jetbrains/exposed/dao/EntityClass;", "getKlass", "()Lorg/jetbrains/exposed/dao/EntityClass;", "<init>", "(Lorg/jetbrains/exposed/dao/EntityClass;)V", "exposed-dao"})
public final class EntityBatchUpdate {
    @NotNull
    private final EntityClass<?, Entity<?>> klass;
    @NotNull
    private final ArrayList<Pair<EntityID<?>, SortedMap<Column<?>, Object>>> data;

    public EntityBatchUpdate(@NotNull EntityClass<?, ? extends Entity<?>> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.klass = klass;
        this.data = new ArrayList();
    }

    @NotNull
    public final EntityClass<?, Entity<?>> getKlass() {
        return this.klass;
    }

    public final void addBatch(@NotNull EntityID<?> id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        if (!Intrinsics.areEqual(id2.getTable(), this.klass.getTable())) {
            throw new IllegalStateException(("Table from Entity ID " + id2.getTable().getTableName() + " differs from entity class " + this.klass.getTable().getTableName()).toString());
        }
        this.data.add(TuplesKt.to(id2, new TreeMap()));
    }

    public final void set(@NotNull Column<?> column, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        SortedMap values2 = (SortedMap)((Pair)CollectionsKt.last((List)this.data)).getSecond();
        if (values2.containsKey(column)) {
            String string = column + " is already initialized";
            throw new IllegalStateException(string.toString());
        }
        ((Map)values2).put(column, value2);
    }

    /*
     * WARNING - void declaration
     */
    public final int execute(@NotNull Transaction transaction2) {
        void $this$fold$iv;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Pair it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Iterable $this$filterNot$iv = this.data;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (((SortedMap)it.getSecond()).isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterNotTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Pair)element$iv$iv;
            boolean bl = false;
            Set key$iv$iv = ((SortedMap)it.getSecond()).keySet();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object updateSets = destination$iv$iv;
        $this$groupBy$iv = updateSets.values();
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void set;
            void it2;
            Object element$iv$iv;
            element$iv$iv = (List)element$iv;
            int acc = accumulator$iv;
            boolean bl = false;
            $this$getOrPut$iv$iv$iv = new BatchUpdateStatement(this.getKlass().getTable());
            int n = acc;
            boolean bl3 = false;
            it2.getData().addAll((Collection)set);
            Object t = it2.execute(transaction2);
            Intrinsics.checkNotNull(t);
            int n2 = ((Number)t).intValue();
            accumulator$iv = n + n2;
        }
        return accumulator$iv;
    }
}

